/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.MXJClassLoaderImpl;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

public class MXJClassLoader {
    private static MXJClassLoader _me = new MXJClassLoader();
    private MXJClassLoaderImpl _instance = null;
    private HashMap _extended_class_cache = null;
    private HashMap _cs_map = null;
    Vector _v_classpath = new Vector(16);
    private String _extended_class_search_dir = null;
    private boolean _zapped = false;

    private MXJClassLoader() {
        this._extended_class_cache = new HashMap(64);
        this._cs_map = new HashMap(64);
    }

    public static MXJClassLoader getInstance() {
        return _me;
    }

    public String[] getCurrentClassPath() {
        return this._instance.getCurrentClassPath();
    }

    public void dump() {
        this._instance.dump();
    }

    public Class loadClazz(String name, boolean resolve, boolean report_error) {
        Class c = null;
        String class_code_source = null;
        File f = null;
        if (this._instance == null) {
            this._instance = new MXJClassLoaderImpl(this._v_classpath, this._extended_class_search_dir);
        }
        try {
            modinfo mi = (modinfo)this._cs_map.get(name);
            if (mi != null && mi.f.lastModified() > mi.initialmod || this._zapped) {
                c = new MXJClassLoaderImpl(this._v_classpath, this._extended_class_search_dir).doLoadClass(name, resolve, report_error);
                this._cs_map.remove(name);
                this._extended_class_cache.remove(name);
                this._zapped = false;
            } else {
                c = (Class)this._extended_class_cache.get(name);
                if (c != null) {
                    return c;
                }
                c = this._instance.doLoadClass(name, resolve, report_error);
            }
            if (this._cs_map.get(name) == null) {
                try {
                    class_code_source = c.getProtectionDomain().getCodeSource().getLocation().getFile();
                    if (!class_code_source.endsWith(".jar")) {
                        class_code_source = class_code_source + name.replace('.', File.separatorChar) + ".class";
                    }
                    f = new File(class_code_source);
                    this._cs_map.put(name, new modinfo(f, f.lastModified()));
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
            if (this._extended_class_cache.get(name) == null) {
                this._extended_class_cache.put(name, c);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return c;
    }

    protected String getCodeSource(String classname) {
        modinfo i = (modinfo)this._cs_map.get(classname);
        if (i == null) {
            return null;
        }
        return i.f.getAbsolutePath();
    }

    protected void addDirectory(String dirname) {
        if (!this._v_classpath.contains(dirname)) {
            this._v_classpath.addElement(dirname);
        }
    }

    protected void setExtendedClassSearchDirectory(String dirname) {
        this._extended_class_search_dir = dirname;
        if (this._instance != null) {
            this._instance.setExtendedClassSearchDirectory(dirname);
        }
    }

    protected String[] getDynamicClassPath() {
        return this.getCurrentClassPath();
    }

    protected void zap() {
        this._zapped = true;
    }

    class modinfo {
        File f;
        long initialmod;

        modinfo(File f_, long lastmodified_) {
            this.f = f_;
            this.initialmod = lastmodified_;
        }
    }
}

