/*
 * Decompiled with CFR 0.152.
 */
package jode.decompiler;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.ImportHandler;
import jode.decompiler.Options;
import jode.decompiler.TabbedPrintWriter;

public class Main
extends Options {
    private static int successCount = 0;
    private static Vector failedClasses;
    private static final int OPTION_START = 65536;
    private static final int OPTION_END = 131072;
    private static final LongOpt[] longOptions;

    public static void usage() {
        PrintWriter printWriter = GlobalOptions.err;
        printWriter.println("Version: 1.1.2-pre1");
        printWriter.println("Usage: java jode.decompiler.Main [OPTION]* {CLASS|JAR}*");
        printWriter.println("Give a fully qualified CLASS name, e.g. jode.decompiler.Main, if you want to");
        printWriter.println("decompile a single class, or a JAR file containing many classes.");
        printWriter.println("OPTION is any of these:");
        printWriter.println("  -h, --help           show this information.");
        printWriter.println("  -V, --version        output version information and exit.");
        printWriter.println("  -v, --verbose        be verbose (multiple times means more verbose).");
        printWriter.println("  -c, --classpath <path> search for classes in specified classpath.");
        printWriter.println("                       The directories should be separated by ','.");
        printWriter.println("  -d, --dest <dir>     write decompiled files to disk into directory destdir.");
        printWriter.println("  -s, --style {sun|gnu}  specify indentation style");
        printWriter.println("  -i, --import <pkglimit>,<clslimit>");
        printWriter.println("                       import classes used more than clslimit times");
        printWriter.println("                       and packages with more then pkglimit used classes.");
        printWriter.println("                       Limit 0 means never import. Default is 0,1.");
        printWriter.println("  -D, --debug=...      use --debug=help for more information.");
        printWriter.println("NOTE: The following options can be turned on or off with `yes' or `no'.");
        printWriter.println("The options tagged with (default) are normally on.  Omitting the yes/no");
        printWriter.println("argument will toggle the option, e.g. --verify is equivalent to --verify=no.");
        printWriter.println("      --inner          decompile inner classes (default).");
        printWriter.println("      --anonymous      decompile anonymous classes (default).");
        printWriter.println("      --contrafo       transform constructors of inner classes (default).");
        printWriter.println("      --lvt            use the local variable table (default).");
        printWriter.println("      --pretty         use `pretty' names for local variables (default).");
        printWriter.println("      --push           allow PUSH instructions in output.");
        printWriter.println("      --decrypt        decrypt encrypted strings (default).");
        printWriter.println("      --onetime        remove locals, that are used only one time.");
        printWriter.println("      --immediate      output source immediately (may produce buggy code).");
        printWriter.println("      --verify         verify code before decompiling it (default).");
    }

    public static boolean handleOption(int n, int n2, String string) {
        if (string == null) {
            Options.options ^= 1 << n;
        } else if ("yes".startsWith(string) || string.equals("on")) {
            Options.options |= 1 << n;
        } else if ("no".startsWith(string) || string.equals("off")) {
            Options.options &= ~(1 << n);
        } else {
            GlobalOptions.err.println("jode.decompiler.Main: option --" + longOptions[n2].getName() + " takes one of `yes', `no', `on', `off' as parameter");
            return false;
        }
        return true;
    }

    public static void decompileClass(String string, ZipOutputStream zipOutputStream, String string2, TabbedPrintWriter tabbedPrintWriter, ImportHandler importHandler) {
        try {
            Object object;
            ClassInfo classInfo;
            try {
                classInfo = ClassInfo.forName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GlobalOptions.err.println("`" + string + "' is not a class name");
                return;
            }
            if (Options.skipClass(classInfo)) {
                return;
            }
            String string3 = string.replace('.', File.separatorChar) + ".java";
            if (zipOutputStream != null) {
                tabbedPrintWriter.flush();
                zipOutputStream.putNextEntry(new ZipEntry(string3));
            } else if (string2 != null) {
                object = new File(string2, string3);
                File file = new File(((File)object).getParent());
                if (!file.exists() && !file.mkdirs()) {
                    GlobalOptions.err.println("Could not create directory " + file.getPath() + ", check permissions.");
                }
                tabbedPrintWriter = new TabbedPrintWriter(new BufferedOutputStream(new FileOutputStream((File)object)), importHandler, false);
            }
            GlobalOptions.err.println(string);
            object = new ClassAnalyzer(classInfo, importHandler);
            ((ClassAnalyzer)object).dumpJavaFile(tabbedPrintWriter);
            if (zipOutputStream != null) {
                tabbedPrintWriter.flush();
                zipOutputStream.closeEntry();
            } else if (string2 != null) {
                tabbedPrintWriter.close();
            }
            System.gc();
            ++successCount;
        }
        catch (IOException iOException) {
            failedClasses.addElement(string);
            GlobalOptions.err.println("Can't write source of " + string + ".");
            GlobalOptions.err.println("Check the permissions.");
            iOException.printStackTrace(GlobalOptions.err);
        }
        catch (Throwable throwable) {
            failedClasses.addElement(string);
            GlobalOptions.err.println("Failed to decompile " + string + ".");
            throwable.printStackTrace(GlobalOptions.err);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Main.decompile(stringArray);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            exceptionInInitializerError.getException().printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Main.printSummary();
        System.exit(0);
    }

    private static void printSummary() {
        GlobalOptions.err.println();
        if (failedClasses.size() > 0) {
            GlobalOptions.err.println("Failed to decompile these classes:");
            Enumeration enumeration = failedClasses.elements();
            while (enumeration.hasMoreElements()) {
                GlobalOptions.err.println("\t" + enumeration.nextElement());
            }
            GlobalOptions.err.println("Failed to decompile " + failedClasses.size() + " classes.");
        }
        GlobalOptions.err.println("Decompiled " + successCount + " classes.");
    }

    public static void decompile(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            Main.usage();
            return;
        }
        failedClasses = new Vector();
        String string = System.getProperty("java.class.path").replace(File.pathSeparatorChar, ',');
        String string2 = System.getProperty("sun.boot.class.path");
        if (string2 != null) {
            string = string + "," + string2.replace(File.pathSeparatorChar, ',');
        }
        String string3 = null;
        int n = Integer.MAX_VALUE;
        int n2 = 1;
        GlobalOptions.err.println("Jode (c) 1998-2001 Jochen Hoenicke <jochen@gnu.org>");
        boolean bl = false;
        Getopt getopt = new Getopt("jode.decompiler.Main", stringArray, "hVvc:d:D:i:s:", longOptions, true);
        int n3 = getopt.getopt();
        while (n3 != -1) {
            switch (n3) {
                case 0: {
                    break;
                }
                case 104: {
                    Main.usage();
                    bl = true;
                    break;
                }
                case 86: {
                    GlobalOptions.err.println("1.1.2-pre1");
                    break;
                }
                case 99: {
                    string = getopt.getOptarg();
                    break;
                }
                case 100: {
                    string3 = getopt.getOptarg();
                    break;
                }
                case 118: {
                    object = getopt.getOptarg();
                    if (object == null) {
                        ++GlobalOptions.verboseLevel;
                        break;
                    }
                    try {
                        GlobalOptions.verboseLevel = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        GlobalOptions.err.println("jode.decompiler.Main: Argument `" + (String)object + "' to --verbose must be numeric:");
                        bl = true;
                    }
                    break;
                }
                case 68: {
                    object = getopt.getOptarg();
                    if (object == null) {
                        object = "help";
                    }
                    bl |= !GlobalOptions.setDebugging((String)object);
                    break;
                }
                case 115: {
                    object = getopt.getOptarg();
                    if ("sun".startsWith((String)object)) {
                        Options.outputStyle = 20;
                        break;
                    }
                    if ("gnu".startsWith((String)object)) {
                        Options.outputStyle = 66;
                        break;
                    }
                    if ("pascal".startsWith((String)object)) {
                        Options.outputStyle = 36;
                        break;
                    }
                    GlobalOptions.err.println("jode.decompiler.Main: Unknown style `" + (String)object + "'.");
                    bl = true;
                    break;
                }
                case 105: {
                    object = getopt.getOptarg();
                    int n4 = ((String)object).indexOf(44);
                    try {
                        int n5 = Integer.parseInt(((String)object).substring(0, n4));
                        if (n5 == 0) {
                            n5 = Integer.MAX_VALUE;
                        }
                        if (n5 < 0) {
                            throw new IllegalArgumentException();
                        }
                        int n6 = Integer.parseInt(((String)object).substring(n4 + 1));
                        if (n6 == 0) {
                            n6 = Integer.MAX_VALUE;
                        }
                        if (n6 < 0) {
                            throw new IllegalArgumentException();
                        }
                        n = n5;
                        n2 = n6;
                    }
                    catch (RuntimeException runtimeException) {
                        GlobalOptions.err.println("jode.decompiler.Main: Invalid argument for -i option.");
                        bl = true;
                    }
                    break;
                }
                default: {
                    if (n3 >= 65536 && n3 <= 131072) {
                        bl |= !Main.handleOption(n3 - 65536, getopt.getLongind(), getopt.getOptarg());
                        break;
                    }
                    bl = true;
                    break;
                }
            }
            n3 = getopt.getopt();
        }
        if (bl) {
            return;
        }
        ClassInfo.setClassPath(string);
        ImportHandler importHandler = new ImportHandler(n, n2);
        object = null;
        TabbedPrintWriter tabbedPrintWriter = null;
        if (string3 == null) {
            tabbedPrintWriter = new TabbedPrintWriter(System.out, importHandler);
        } else if (string3.toLowerCase().endsWith(".zip") || string3.toLowerCase().endsWith(".jar")) {
            try {
                object = new ZipOutputStream(new FileOutputStream(string3));
            }
            catch (IOException iOException) {
                GlobalOptions.err.println("Can't open zip file " + string3);
                iOException.printStackTrace(GlobalOptions.err);
                return;
            }
            tabbedPrintWriter = new TabbedPrintWriter(new BufferedOutputStream((OutputStream)object), importHandler, false);
        }
        int n7 = getopt.getOptind();
        while (n7 < stringArray.length) {
            try {
                if ((stringArray[n7].endsWith(".jar") || stringArray[n7].endsWith(".zip")) && new File(stringArray[n7]).isFile()) {
                    ClassInfo.setClassPath(stringArray[n7] + "," + string);
                    Enumeration<? extends ZipEntry> enumeration = new ZipFile(stringArray[n7]).entries();
                    while (enumeration.hasMoreElements()) {
                        String string4 = enumeration.nextElement().getName();
                        if (!string4.endsWith(".class")) continue;
                        string4 = string4.substring(0, string4.length() - 6).replace('/', '.');
                        Main.decompileClass(string4, (ZipOutputStream)object, string3, tabbedPrintWriter, importHandler);
                    }
                    ClassInfo.setClassPath(string);
                } else {
                    Main.decompileClass(stringArray[n7], (ZipOutputStream)object, string3, tabbedPrintWriter, importHandler);
                }
            }
            catch (IOException iOException) {
                GlobalOptions.err.println("Can't read zip file " + stringArray[n7] + ".");
                iOException.printStackTrace(GlobalOptions.err);
            }
            ++n7;
        }
        if (object != null) {
            try {
                ((ZipOutputStream)object).close();
            }
            catch (IOException iOException) {
                GlobalOptions.err.println("Can't close Zipfile");
                iOException.printStackTrace(GlobalOptions.err);
            }
        }
    }

    static {
        longOptions = new LongOpt[]{new LongOpt("cp", 1, null, 99), new LongOpt("classpath", 1, null, 99), new LongOpt("dest", 1, null, 100), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 86), new LongOpt("verbose", 2, null, 118), new LongOpt("debug", 2, null, 68), new LongOpt("import", 1, null, 105), new LongOpt("style", 1, null, 115), new LongOpt("lvt", 2, null, 65536), new LongOpt("inner", 2, null, 65537), new LongOpt("anonymous", 2, null, 65538), new LongOpt("push", 2, null, 65539), new LongOpt("pretty", 2, null, 65540), new LongOpt("decrypt", 2, null, 65541), new LongOpt("onetime", 2, null, 65542), new LongOpt("immediate", 2, null, 65543), new LongOpt("verify", 2, null, 65544), new LongOpt("contrafo", 2, null, 65545)};
    }
}

