/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jode.AssertError;
import jode.GlobalOptions;
import jode.decompiler.LocalInfo;
import jode.decompiler.MethodAnalyzer;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CombineableOperator;
import jode.expr.Expression;
import jode.flow.BreakBlock;
import jode.flow.BreakableBlock;
import jode.flow.ConditionalBlock;
import jode.flow.ContinueBlock;
import jode.flow.DescriptionBlock;
import jode.flow.EmptyBlock;
import jode.flow.FinallyBlock;
import jode.flow.IfThenElseBlock;
import jode.flow.InstructionBlock;
import jode.flow.InstructionContainer;
import jode.flow.Jump;
import jode.flow.LoopBlock;
import jode.flow.ReturnBlock;
import jode.flow.SequentialBlock;
import jode.flow.SlotSet;
import jode.flow.StructuredBlock;
import jode.flow.SwitchBlock;
import jode.flow.TryBlock;
import jode.flow.VariableSet;
import jode.flow.VariableStack;
import jode.util.SimpleMap;

public class FlowBlock {
    public static FlowBlock END_OF_METHOD = new FlowBlock(null, Integer.MAX_VALUE);
    public static FlowBlock NEXT_BY_ADDR;
    static int serialno;
    MethodAnalyzer method;
    private SlotSet in = new SlotSet();
    VariableSet gen = new VariableSet();
    private int addr;
    private int length;
    StructuredBlock block;
    StructuredBlock lastModified;
    private Map successors = new SimpleMap();
    List predecessors = new ArrayList();
    FlowBlock nextByAddr;
    FlowBlock prevByAddr;
    VariableStack stackMap;
    String label = null;

    public final int getNextAddr() {
        return this.addr + this.length;
    }

    public boolean hasNoJumps() {
        return this.successors.size() == 0 && this.predecessors.size() == 0;
    }

    public Jump resolveSomeJumps(Jump jump, FlowBlock flowBlock) {
        Object object;
        StructuredBlock structuredBlock;
        StructuredBlock structuredBlock2;
        Jump jump2;
        Jump jump3 = null;
        if (this.lastModified.jump == null) {
            jump2 = new Jump(flowBlock);
            this.lastModified.setJump(jump2);
            jump3 = jump2;
        }
        jump2 = jump;
        while (jump2 != null) {
            if (jump2.prev.outer instanceof ConditionalBlock && jump2.prev.outer.jump != null) {
                structuredBlock2 = jump2.prev;
                structuredBlock = (ConditionalBlock)structuredBlock2.outer;
                object = ((InstructionContainer)structuredBlock).getInstruction();
                ((InstructionContainer)structuredBlock).setInstruction(((Expression)object).negate());
                structuredBlock.swapJump(structuredBlock2);
            }
            jump2 = jump2.next;
        }
        while (jump != null) {
            StructuredBlock structuredBlock3;
            jump2 = jump;
            jump = jump.next;
            if (jump2.prev == this.lastModified) {
                jump2.next = jump3;
                jump3 = jump2;
                continue;
            }
            if (jump2.prev.outer instanceof ConditionalBlock) {
                StructuredBlock structuredBlock4;
                structuredBlock2 = jump2.prev;
                structuredBlock = (ConditionalBlock)structuredBlock2.outer;
                object = ((InstructionContainer)structuredBlock).getInstruction();
                if (structuredBlock.jump != null) {
                    structuredBlock2.removeJump();
                    structuredBlock3 = new IfThenElseBlock(((InstructionContainer)structuredBlock).getInstruction().negate());
                    structuredBlock3.moveDefinitions(structuredBlock, structuredBlock2);
                    structuredBlock3.replace(structuredBlock);
                    structuredBlock3.moveJump(structuredBlock.jump);
                    ((IfThenElseBlock)structuredBlock3).setThenBlock(structuredBlock2);
                    if (structuredBlock != this.lastModified) continue;
                    this.lastModified = structuredBlock3;
                    continue;
                }
                if (structuredBlock.outer instanceof LoopBlock || structuredBlock.outer instanceof SequentialBlock && structuredBlock.outer.getSubBlocks()[0] == structuredBlock && structuredBlock.outer.outer instanceof LoopBlock) {
                    StructuredBlock structuredBlock5 = structuredBlock3 = structuredBlock.outer instanceof LoopBlock ? (LoopBlock)structuredBlock.outer : (LoopBlock)structuredBlock.outer.outer;
                    if (((LoopBlock)structuredBlock3).getCondition() == LoopBlock.TRUE && ((LoopBlock)structuredBlock3).getType() != 1 && (((LoopBlock)structuredBlock3).jumpMayBeChanged() || structuredBlock3.getNextFlowBlock() == flowBlock)) {
                        if (structuredBlock3.jump == null) {
                            structuredBlock3.moveJump(jump2);
                            jump = jump2;
                        } else {
                            jump2.prev.removeJump();
                        }
                        ((LoopBlock)structuredBlock3).setCondition(((Expression)object).negate());
                        structuredBlock3.moveDefinitions(structuredBlock, null);
                        structuredBlock.removeBlock();
                        continue;
                    }
                } else if (structuredBlock.outer instanceof SequentialBlock && structuredBlock.outer.getSubBlocks()[1] == structuredBlock) {
                    structuredBlock3 = structuredBlock.outer.outer;
                    while (structuredBlock3 instanceof SequentialBlock) {
                        structuredBlock3 = structuredBlock3.outer;
                    }
                    if (structuredBlock3 instanceof LoopBlock && ((LoopBlock)(structuredBlock4 = (LoopBlock)structuredBlock3)).getCondition() == LoopBlock.TRUE && ((LoopBlock)structuredBlock4).getType() == 0 && (((LoopBlock)structuredBlock4).jumpMayBeChanged() || structuredBlock4.getNextFlowBlock() == flowBlock)) {
                        if (structuredBlock4.jump == null) {
                            structuredBlock4.moveJump(jump2);
                            jump = jump2;
                        } else {
                            jump2.prev.removeJump();
                        }
                        ((LoopBlock)structuredBlock4).setType(1);
                        ((LoopBlock)structuredBlock4).setCondition(((Expression)object).negate());
                        structuredBlock4.moveDefinitions(structuredBlock, null);
                        structuredBlock.removeBlock();
                        continue;
                    }
                }
                if (structuredBlock.outer instanceof SequentialBlock && structuredBlock.outer.getSubBlocks()[0] == structuredBlock && (structuredBlock.outer.getNextFlowBlock() == flowBlock || structuredBlock.outer.jumpMayBeChanged())) {
                    structuredBlock3 = (SequentialBlock)structuredBlock.outer;
                    structuredBlock4 = new IfThenElseBlock(((Expression)object).negate());
                    StructuredBlock structuredBlock6 = ((SequentialBlock)structuredBlock3).getSubBlocks()[1];
                    structuredBlock4.moveDefinitions(structuredBlock3, structuredBlock6);
                    structuredBlock4.replace(structuredBlock3);
                    ((IfThenElseBlock)structuredBlock4).setThenBlock(structuredBlock6);
                    if (structuredBlock6.contains(this.lastModified)) {
                        if (this.lastModified.jump.destination == flowBlock) {
                            structuredBlock4.moveJump(this.lastModified.jump);
                            this.lastModified = structuredBlock4;
                            jump2.prev.removeJump();
                            continue;
                        }
                        this.lastModified = structuredBlock4;
                    }
                    structuredBlock4.moveJump(jump2);
                    jump = jump2;
                    continue;
                }
            } else {
                if (jump2.destination == jump2.prev.outer.getNextFlowBlock(jump2.prev)) {
                    jump2.prev.removeJump();
                    continue;
                }
                structuredBlock2 = jump2.prev.outer;
                while (structuredBlock2 instanceof SequentialBlock) {
                    structuredBlock2 = structuredBlock2.outer;
                }
                if (structuredBlock2 instanceof IfThenElseBlock) {
                    structuredBlock = (IfThenElseBlock)structuredBlock2;
                    if (((IfThenElseBlock)structuredBlock).elseBlock == null && structuredBlock.jump != null) {
                        ((IfThenElseBlock)structuredBlock).setElseBlock(new EmptyBlock());
                        ((IfThenElseBlock)structuredBlock).elseBlock.moveJump(structuredBlock.jump);
                        structuredBlock.moveJump(jump2);
                        jump = jump2;
                        continue;
                    }
                }
                if (structuredBlock2 instanceof IfThenElseBlock && structuredBlock2.outer instanceof SequentialBlock && structuredBlock2.outer.getSubBlocks()[0] == structuredBlock2) {
                    structuredBlock = (IfThenElseBlock)structuredBlock2;
                    object = (SequentialBlock)structuredBlock2.outer;
                    structuredBlock3 = ((SequentialBlock)object).subBlocks[1];
                    if (((IfThenElseBlock)structuredBlock).elseBlock == null && (structuredBlock3.getNextFlowBlock() == flowBlock || structuredBlock3.jump != null || structuredBlock3.jumpMayBeChanged())) {
                        structuredBlock.replace((StructuredBlock)object);
                        ((IfThenElseBlock)structuredBlock).setElseBlock(structuredBlock3);
                        if (structuredBlock3.contains(this.lastModified)) {
                            if (this.lastModified.jump.destination == flowBlock) {
                                structuredBlock.moveJump(this.lastModified.jump);
                                this.lastModified = structuredBlock;
                                jump2.prev.removeJump();
                                continue;
                            }
                            this.lastModified = structuredBlock;
                        }
                        structuredBlock.moveJump(jump2);
                        jump = jump2;
                        continue;
                    }
                }
            }
            structuredBlock2 = jump2.prev.outer;
            while (structuredBlock2 != null) {
                if (structuredBlock2 instanceof BreakableBlock) {
                    if (structuredBlock2.getNextFlowBlock() == flowBlock) break;
                    if (structuredBlock2.jumpMayBeChanged()) {
                        structuredBlock2.setJump(new Jump(flowBlock));
                        structuredBlock2.jump.next = jump;
                        jump = structuredBlock2.jump;
                        break;
                    }
                    if (flowBlock == END_OF_METHOD) break;
                }
                structuredBlock2 = structuredBlock2.outer;
            }
            jump2.next = jump3;
            jump3 = jump2;
        }
        return jump3;
    }

    void resolveRemaining(Jump jump) {
        StructuredBlock structuredBlock = null;
        StructuredBlock structuredBlock2 = this.lastModified;
        boolean bl = false;
        while (jump != null) {
            StructuredBlock structuredBlock3 = jump.prev;
            if (structuredBlock3 == this.lastModified) {
                bl = true;
            } else {
                int n = 0;
                BreakableBlock breakableBlock = null;
                StructuredBlock structuredBlock4 = structuredBlock3.outer;
                while (structuredBlock4 != null) {
                    if (structuredBlock4 instanceof BreakableBlock) {
                        ++n;
                        if (structuredBlock4.getNextFlowBlock() == jump.destination) {
                            breakableBlock = (BreakableBlock)((Object)structuredBlock4);
                            break;
                        }
                    }
                    structuredBlock4 = structuredBlock4.outer;
                }
                structuredBlock3.removeJump();
                if (breakableBlock == null) {
                    if (structuredBlock == null) {
                        structuredBlock = new LoopBlock(1, LoopBlock.FALSE);
                    }
                    while (!structuredBlock2.contains(structuredBlock3)) {
                        structuredBlock2 = structuredBlock2.outer;
                    }
                    structuredBlock3.appendBlock(new BreakBlock((BreakableBlock)((Object)structuredBlock), n > 0));
                } else {
                    structuredBlock3.appendBlock(new BreakBlock(breakableBlock, n > 1));
                }
            }
            jump = jump.next;
        }
        if (bl) {
            this.lastModified.removeJump();
        }
        if (structuredBlock != null) {
            structuredBlock.replace(structuredBlock2);
            ((LoopBlock)structuredBlock).setBody(structuredBlock2);
            this.lastModified = structuredBlock;
        }
    }

    void mergeSuccessors(FlowBlock flowBlock) {
        Iterator iterator = flowBlock.successors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            FlowBlock flowBlock2 = (FlowBlock)entry.getKey();
            SuccessorInfo successorInfo = (SuccessorInfo)entry.getValue();
            SuccessorInfo successorInfo2 = (SuccessorInfo)this.successors.get(flowBlock2);
            if (flowBlock2 != END_OF_METHOD) {
                flowBlock2.predecessors.remove(flowBlock);
            }
            if (successorInfo2 == null) {
                if (flowBlock2 != END_OF_METHOD) {
                    flowBlock2.predecessors.add(this);
                }
                this.successors.put(flowBlock2, successorInfo);
                continue;
            }
            successorInfo2.gen.addAll(successorInfo.gen);
            successorInfo2.kill.retainAll(successorInfo.kill);
            Jump jump = successorInfo2.jumps;
            while (jump.next != null) {
                jump = jump.next;
            }
            jump.next = successorInfo.jumps;
        }
    }

    public void mergeAddr(FlowBlock flowBlock) {
        if (flowBlock.nextByAddr == this || flowBlock.prevByAddr == null) {
            flowBlock.nextByAddr.addr = flowBlock.addr;
            flowBlock.nextByAddr.length += flowBlock.length;
            flowBlock.nextByAddr.prevByAddr = flowBlock.prevByAddr;
            if (flowBlock.prevByAddr != null) {
                flowBlock.prevByAddr.nextByAddr = flowBlock.nextByAddr;
            }
        } else {
            flowBlock.prevByAddr.length += flowBlock.length;
            flowBlock.prevByAddr.nextByAddr = flowBlock.nextByAddr;
            if (flowBlock.nextByAddr != null) {
                flowBlock.nextByAddr.prevByAddr = flowBlock.prevByAddr;
            }
        }
    }

    void updateInOut(FlowBlock flowBlock, SuccessorInfo successorInfo) {
        SlotSet slotSet = successorInfo.kill;
        VariableSet variableSet = successorInfo.gen;
        flowBlock.in.merge(variableSet);
        SlotSet slotSet2 = (SlotSet)flowBlock.in.clone();
        slotSet2.removeAll(slotSet);
        Iterator iterator = flowBlock.successors.values().iterator();
        while (iterator.hasNext()) {
            SuccessorInfo successorInfo2 = (SuccessorInfo)iterator.next();
            successorInfo2.gen.mergeGenKill(variableSet, successorInfo2.kill);
            if (flowBlock == this) continue;
            successorInfo2.kill.mergeKill(slotSet);
        }
        this.in.addAll(slotSet2);
        this.gen.addAll(flowBlock.gen);
        if ((GlobalOptions.debuggingFlags & 0x10) != 0) {
            GlobalOptions.err.println("UpdateInOut: gens : " + variableSet);
            GlobalOptions.err.println("             kills: " + slotSet);
            GlobalOptions.err.println("             s.in : " + flowBlock.in);
            GlobalOptions.err.println("             in   : " + this.in);
        }
    }

    public void updateInOutCatch(FlowBlock flowBlock) {
        VariableSet variableSet = ((TryBlock)this.block).gen;
        flowBlock.in.merge(variableSet);
        Iterator iterator = flowBlock.successors.values().iterator();
        while (iterator.hasNext()) {
            SuccessorInfo successorInfo = (SuccessorInfo)iterator.next();
            successorInfo.gen.mergeGenKill(variableSet, successorInfo.kill);
        }
        this.in.addAll(flowBlock.in);
        this.gen.addAll(flowBlock.gen);
        if ((GlobalOptions.debuggingFlags & 0x10) != 0) {
            GlobalOptions.err.println("UpdateInOutCatch: gens : " + variableSet);
            GlobalOptions.err.println("                  s.in : " + flowBlock.in);
            GlobalOptions.err.println("                  in   : " + this.in);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkConsistent() {
        if ((GlobalOptions.debuggingFlags & 128) == 0) {
            return;
        }
        try {
            if (this.block.outer != null || this.block.flowBlock != this) {
                throw new AssertError("Inconsistency");
            }
            this.block.checkConsistent();
            var1_1 = this.predecessors.iterator();
            while (var1_1.hasNext()) {
                var2_3 = (FlowBlock)var1_1.next();
                if (var2_3 == null || var2_3.successors.containsKey(this)) continue;
                throw new AssertError("Inconsistency");
            }
            var1_1 = this.lastModified;
            while (var1_1.outer instanceof SequentialBlock || var1_1.outer instanceof TryBlock || var1_1.outer instanceof FinallyBlock) {
                var1_1 = var1_1.outer;
            }
            if (var1_1.outer != null) {
                throw new AssertError("Inconsistency");
            }
            var2_3 = this.successors.entrySet().iterator();
            while (var2_3.hasNext()) {
                var3_4 = (Map.Entry)var2_3.next();
                var4_5 = (FlowBlock)var3_4.getKey();
                if (var4_5.predecessors.contains(this) == (var4_5 == FlowBlock.END_OF_METHOD)) {
                    throw new AssertError("Inconsistency");
                }
                var5_6 = ((SuccessorInfo)var3_4.getValue()).jumps;
                if (var5_6 != null) ** GOTO lbl47
                throw new AssertError("Inconsistency");
lbl-1000:
                // 1 sources

                {
                    if (var5_6.destination != var4_5) {
                        throw new AssertError("Inconsistency");
                    }
                    if (var5_6.prev == null || var5_6.prev.flowBlock != this || var5_6.prev.jump != var5_6) {
                        throw new AssertError("Inconsistency");
                    }
                    var6_7 = var5_6.prev;
                    while (var6_7 != this.block) {
                        block16: {
                            if (var6_7.outer == null) {
                                throw new RuntimeException("Inconsistency");
                            }
                            var7_8 = var6_7.outer.getSubBlocks();
                            var8_9 = 0;
                            while (var8_9 < var7_8.length) {
                                if (var7_8[var8_9] != var6_7) {
                                    ++var8_9;
                                    continue;
                                }
                                break block16;
                            }
                            throw new AssertError("Inconsistency");
                        }
                        var6_7 = var6_7.outer;
                    }
                    var5_6 = var5_6.next;
lbl47:
                    // 2 sources

                    ** while (var5_6 != null)
                }
lbl48:
                // 1 sources

            }
        }
        catch (AssertError var1_2) {
            GlobalOptions.err.println("Inconsistency in: " + this);
            throw var1_2;
        }
    }

    public void appendBlock(StructuredBlock structuredBlock, int n) {
        SlotSet slotSet = new SlotSet();
        SlotSet slotSet2 = new SlotSet();
        VariableSet variableSet = new VariableSet();
        structuredBlock.fillInGenSet(slotSet, slotSet2);
        variableSet.addAll(slotSet2);
        if (this.block == null) {
            this.block = structuredBlock;
            this.lastModified = structuredBlock;
            structuredBlock.setFlowBlock(this);
            structuredBlock.fillSuccessors();
            this.length = n;
            this.in = slotSet;
            this.gen = variableSet;
            Iterator iterator = this.successors.values().iterator();
            while (iterator.hasNext()) {
                SuccessorInfo successorInfo = (SuccessorInfo)iterator.next();
                successorInfo.gen = new VariableSet();
                successorInfo.kill = new SlotSet();
                successorInfo.gen.addAll(variableSet);
                successorInfo.kill.addAll(slotSet2);
            }
        } else if (!(structuredBlock instanceof EmptyBlock)) {
            this.checkConsistent();
            if ((GlobalOptions.debuggingFlags & 8) != 0) {
                GlobalOptions.err.println("appending Block: " + structuredBlock);
            }
            SuccessorInfo successorInfo = (SuccessorInfo)this.successors.get(NEXT_BY_ADDR);
            slotSet.merge(successorInfo.gen);
            slotSet.removeAll(successorInfo.kill);
            variableSet.mergeGenKill(successorInfo.gen, slotSet2);
            slotSet2.mergeKill(successorInfo.kill);
            this.in.addAll(slotSet);
            this.gen.addAll(slotSet2);
            this.removeSuccessor(this.lastModified.jump);
            this.lastModified.removeJump();
            this.lastModified = this.lastModified.appendBlock(structuredBlock);
            structuredBlock.fillSuccessors();
            successorInfo = (SuccessorInfo)this.successors.get(NEXT_BY_ADDR);
            successorInfo.gen = variableSet;
            successorInfo.kill = slotSet2;
            this.length += n;
            this.checkConsistent();
            this.doTransformations();
        }
        this.checkConsistent();
    }

    public void setNextByAddr(FlowBlock flowBlock) {
        if (flowBlock == END_OF_METHOD || flowBlock == NEXT_BY_ADDR) {
            throw new IllegalArgumentException("nextByAddr mustn't be special");
        }
        SuccessorInfo successorInfo = (SuccessorInfo)this.successors.remove(NEXT_BY_ADDR);
        SuccessorInfo successorInfo2 = (SuccessorInfo)this.successors.get(flowBlock);
        if (successorInfo != null) {
            FlowBlock.NEXT_BY_ADDR.predecessors.remove(this);
            Jump jump = successorInfo.jumps;
            jump.destination = flowBlock;
            while (jump.next != null) {
                jump = jump.next;
                jump.destination = flowBlock;
            }
            this.successors.put(flowBlock, successorInfo);
            if (successorInfo2 != null) {
                successorInfo.gen.addAll(successorInfo2.gen);
                successorInfo.kill.retainAll(successorInfo2.kill);
                jump.next = successorInfo2.jumps;
            } else {
                flowBlock.predecessors.add(this);
            }
        }
        this.checkConsistent();
        this.nextByAddr = flowBlock;
        flowBlock.prevByAddr = this;
    }

    public boolean doT2(FlowBlock flowBlock) {
        if (flowBlock.predecessors.size() != 1 || flowBlock.predecessors.get(0) != this) {
            return false;
        }
        this.checkConsistent();
        flowBlock.checkConsistent();
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("T2([" + this.addr + "," + this.getNextAddr() + "],[" + flowBlock.addr + "," + flowBlock.getNextAddr() + "])");
        }
        SuccessorInfo successorInfo = (SuccessorInfo)this.successors.remove(flowBlock);
        this.updateInOut(flowBlock, successorInfo);
        if ((GlobalOptions.debuggingFlags & 8) != 0) {
            GlobalOptions.err.println("before Resolve: " + this);
        }
        Jump jump = this.resolveSomeJumps(successorInfo.jumps, flowBlock);
        if ((GlobalOptions.debuggingFlags & 8) != 0) {
            GlobalOptions.err.println("before Remaining: " + this);
        }
        this.resolveRemaining(jump);
        if ((GlobalOptions.debuggingFlags & 8) != 0) {
            GlobalOptions.err.println("after Resolve: " + this);
        }
        this.lastModified = this.lastModified.appendBlock(flowBlock.block);
        this.mergeSuccessors(flowBlock);
        this.doTransformations();
        this.mergeAddr(flowBlock);
        this.checkConsistent();
        return true;
    }

    public void mergeEndBlock() {
        Object object;
        this.checkConsistent();
        SuccessorInfo successorInfo = (SuccessorInfo)this.successors.remove(END_OF_METHOD);
        if (successorInfo == null) {
            return;
        }
        Jump jump = successorInfo.jumps;
        Object object2 = null;
        while (jump != null) {
            object = jump;
            jump = jump.next;
            if (((Jump)object).prev instanceof ReturnBlock) {
                ((Jump)object).prev.removeJump();
                continue;
            }
            ((Jump)object).next = object2;
            object2 = object;
        }
        object2 = this.resolveSomeJumps((Jump)object2, END_OF_METHOD);
        while (object2 != null) {
            object = ((Jump)object2).prev;
            if (this.lastModified != object) {
                BreakableBlock breakableBlock = null;
                StructuredBlock structuredBlock = ((StructuredBlock)object).outer;
                while (structuredBlock != null) {
                    if (structuredBlock instanceof BreakableBlock) {
                        if (structuredBlock.getNextFlowBlock() != END_OF_METHOD) break;
                        breakableBlock = (BreakableBlock)((Object)structuredBlock);
                        break;
                    }
                    structuredBlock = structuredBlock.outer;
                }
                ((StructuredBlock)object).removeJump();
                if (breakableBlock == null) {
                    ((StructuredBlock)object).appendBlock(new ReturnBlock());
                } else {
                    ((StructuredBlock)object).appendBlock(new BreakBlock(breakableBlock, false));
                }
            }
            object2 = ((Jump)object2).next;
        }
        if (this.lastModified.jump.destination == END_OF_METHOD) {
            this.lastModified.removeJump();
        }
        this.doTransformations();
        this.checkConsistent();
    }

    public boolean doT1(int n, int n2) {
        StructuredBlock structuredBlock;
        LoopBlock loopBlock;
        Object object;
        if (!this.predecessors.contains(this)) {
            return false;
        }
        Object object2 = this.predecessors.iterator();
        while (object2.hasNext()) {
            object = (FlowBlock)object2.next();
            if (object == null || object == this || ((FlowBlock)object).addr < n || ((FlowBlock)object).addr >= n2) continue;
            return false;
        }
        this.checkConsistent();
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("T1([" + this.addr + "," + this.getNextAddr() + "])");
        }
        object2 = (SuccessorInfo)this.successors.remove(this);
        this.updateInOut(this, (SuccessorInfo)object2);
        object = ((SuccessorInfo)object2).jumps;
        StructuredBlock structuredBlock2 = this.block;
        boolean bl = false;
        if (((Jump)object).next == null && ((Jump)object).prev == this.lastModified && this.lastModified instanceof InstructionBlock && ((InstructionBlock)this.lastModified).getInstruction().isVoid()) {
            if (this.lastModified.outer instanceof SequentialBlock && this.lastModified.outer.getSubBlocks()[0] instanceof LoopBlock) {
                loopBlock = (LoopBlock)this.lastModified.outer.getSubBlocks()[0];
                if (loopBlock.cond == LoopBlock.FALSE && loopBlock.type == 1) {
                    this.lastModified.removeJump();
                    structuredBlock = new LoopBlock(2, LoopBlock.TRUE);
                    structuredBlock.replace(structuredBlock2);
                    ((LoopBlock)structuredBlock).setBody(structuredBlock2);
                    ((LoopBlock)structuredBlock).incrInstr = ((InstructionBlock)this.lastModified).getInstruction();
                    ((LoopBlock)structuredBlock).replaceBreakContinue(loopBlock);
                    loopBlock.bodyBlock.replace(this.lastModified.outer);
                    bl = true;
                }
            }
            if (!bl && ((InstructionBlock)this.lastModified).getInstruction() instanceof CombineableOperator) {
                this.lastModified.removeJump();
                loopBlock = new LoopBlock(3, LoopBlock.TRUE);
                loopBlock.replace(structuredBlock2);
                loopBlock.setBody(structuredBlock2);
                loopBlock.incrBlock = (InstructionBlock)this.lastModified;
                bl = true;
            }
        }
        if (!bl) {
            object = this.resolveSomeJumps((Jump)object, this);
            loopBlock = new LoopBlock(0, LoopBlock.TRUE);
            structuredBlock2 = this.block;
            loopBlock.replace(structuredBlock2);
            loopBlock.setBody(structuredBlock2);
            while (object != null) {
                if (((Jump)object).prev != this.lastModified) {
                    structuredBlock = ((Jump)object).prev;
                    int n3 = 0;
                    int n4 = 0;
                    BreakableBlock breakableBlock = null;
                    StructuredBlock structuredBlock3 = structuredBlock.outer;
                    while (structuredBlock3 != loopBlock) {
                        if (structuredBlock3 instanceof BreakableBlock) {
                            if (structuredBlock3 instanceof LoopBlock) {
                                ++n4;
                            }
                            ++n3;
                            if (structuredBlock3.getNextFlowBlock() == this) {
                                breakableBlock = (BreakableBlock)((Object)structuredBlock3);
                                break;
                            }
                        }
                        structuredBlock3 = structuredBlock3.outer;
                    }
                    structuredBlock.removeJump();
                    if (breakableBlock == null) {
                        structuredBlock.appendBlock(new ContinueBlock(loopBlock, n4 > 0));
                    } else {
                        structuredBlock.appendBlock(new BreakBlock(breakableBlock, n3 > 1));
                    }
                }
                object = ((Jump)object).next;
            }
            if (this.lastModified.jump.destination == this) {
                this.lastModified.removeJump();
            }
        }
        this.predecessors.remove(this);
        this.lastModified = this.block;
        this.doTransformations();
        this.checkConsistent();
        return true;
    }

    public void doTransformations() {
        if ((GlobalOptions.debuggingFlags & 8) != 0) {
            GlobalOptions.err.println("before Transformation: " + this);
        }
        while (this.lastModified instanceof SequentialBlock) {
            if (this.lastModified.getSubBlocks()[0].doTransformations()) continue;
            this.lastModified = this.lastModified.getSubBlocks()[1];
        }
        while (this.lastModified.doTransformations()) {
        }
        if ((GlobalOptions.debuggingFlags & 8) != 0) {
            GlobalOptions.err.println("after Transformation: " + this);
        }
    }

    FlowBlock getSuccessor(int n, int n2) {
        Iterator iterator = this.successors.keySet().iterator();
        FlowBlock flowBlock = null;
        while (iterator.hasNext()) {
            FlowBlock flowBlock2 = (FlowBlock)iterator.next();
            if (flowBlock2.addr < n || flowBlock2.addr >= n2 || flowBlock2 == this || flowBlock != null && flowBlock2.addr >= flowBlock.addr) continue;
            flowBlock = flowBlock2;
        }
        return flowBlock;
    }

    public void analyze() {
        this.analyze(0, Integer.MAX_VALUE);
        this.mergeEndBlock();
    }

    /*
     * Unable to fully structure code
     */
    public boolean analyze(int var1_1, int var2_2) {
        if ((GlobalOptions.debuggingFlags & 32) != 0) {
            GlobalOptions.err.println("analyze(" + var1_1 + ", " + var2_2 + ")");
        }
        this.checkConsistent();
        var3_3 = false;
        block0: while (true) {
            if (this.lastModified instanceof SwitchBlock) {
                this.analyzeSwitch(var1_1, var2_2);
            }
            if (this.doT1(var1_1, var2_2)) {
                if ((GlobalOptions.debuggingFlags & 8) != 0) {
                    GlobalOptions.err.println("after T1: " + this);
                }
                if (this.addr != 0) {
                    return true;
                }
            }
            var4_4 = this.getSuccessor(var1_1, var2_2);
            while (true) {
                if (var4_4 == null) {
                    if ((GlobalOptions.debuggingFlags & 32) != 0) {
                        GlobalOptions.err.println("No more successors applicable: " + var1_1 + " - " + var2_2 + "; " + this.addr + " - " + this.getNextAddr());
                    }
                    return var3_3;
                }
                if ((this.nextByAddr == var4_4 || var4_4.nextByAddr == this) && this.doT2(var4_4)) {
                    var3_3 = true;
                    if ((GlobalOptions.debuggingFlags & 8) == 0) continue block0;
                    GlobalOptions.err.println("after T2: " + this);
                    continue block0;
                }
                var5_6 = var4_4.predecessors.iterator();
                while (var5_6.hasNext()) {
                    var6_7 = ((FlowBlock)var5_6.next()).addr;
                    if (var6_7 >= var1_1 && var6_7 < var2_2) continue;
                    if ((GlobalOptions.debuggingFlags & 32) != 0) {
                        GlobalOptions.err.println("breaking analyze(" + var1_1 + ", " + var2_2 + "); " + this.addr + " - " + this.getNextAddr());
                    }
                    return var3_3;
                }
                var5_5 = var4_4.addr > this.addr ? this.getNextAddr() : var1_1;
                v0 = var6_7 = var4_4.addr > this.addr ? var2_2 : this.addr;
                if (!var4_4.analyze(var5_5, var6_7)) ** break;
                continue block0;
                var4_4 = this.getSuccessor(var4_4.addr + 1, var2_2);
            }
            break;
        }
    }

    public boolean analyzeSwitch(int n, int n2) {
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("analyzeSwitch(" + n + ", " + n2 + ")");
        }
        SwitchBlock switchBlock = (SwitchBlock)this.lastModified;
        boolean bl = false;
        int n3 = -1;
        FlowBlock flowBlock = null;
        int n4 = 0;
        while (n4 < switchBlock.caseBlocks.length) {
            if (switchBlock.caseBlocks[n4].subBlock instanceof EmptyBlock && switchBlock.caseBlocks[n4].subBlock.jump != null) {
                FlowBlock flowBlock2 = switchBlock.caseBlocks[n4].subBlock.jump.destination;
                if (flowBlock2.addr >= n2) break;
                if (flowBlock2.addr >= n) {
                    while (flowBlock2.analyze(this.getNextAddr(), n2)) {
                        bl = true;
                    }
                    if (flowBlock2.addr != this.getNextAddr() || flowBlock2.predecessors.size() > 2 || flowBlock2.predecessors.size() > 1 && (flowBlock == null || !flowBlock2.predecessors.contains(flowBlock)) || ((SuccessorInfo)this.successors.get((Object)flowBlock2)).jumps.next != null) break;
                    this.checkConsistent();
                    SuccessorInfo successorInfo = (SuccessorInfo)this.successors.remove(flowBlock2);
                    if (flowBlock2.predecessors.size() == 2) {
                        SuccessorInfo successorInfo2 = (SuccessorInfo)flowBlock.successors.remove(flowBlock2);
                        successorInfo.kill.retainAll(successorInfo2.kill);
                        successorInfo.gen.addAll(successorInfo2.gen);
                        Jump jump = flowBlock.resolveSomeJumps(successorInfo2.jumps, flowBlock2);
                        flowBlock.resolveRemaining(jump);
                        switchBlock.caseBlocks[n3 + 1].isFallThrough = true;
                    }
                    this.updateInOut(flowBlock2, successorInfo);
                    if (flowBlock != null) {
                        flowBlock.block.replace(switchBlock.caseBlocks[n3].subBlock);
                        this.mergeSuccessors(flowBlock);
                    }
                    switchBlock.caseBlocks[n4].subBlock.removeJump();
                    this.mergeAddr(flowBlock2);
                    flowBlock = flowBlock2;
                    n3 = n4;
                    this.checkConsistent();
                    bl = true;
                }
            }
            ++n4;
        }
        if (flowBlock != null) {
            flowBlock.block.replace(switchBlock.caseBlocks[n3].subBlock);
            this.mergeSuccessors(flowBlock);
        }
        if ((GlobalOptions.debuggingFlags & 8) != 0) {
            GlobalOptions.err.println("after analyzeSwitch: " + this);
        }
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("analyzeSwitch done: " + n + " - " + n2 + "; " + this.addr + " - " + this.getNextAddr());
        }
        this.checkConsistent();
        return bl;
    }

    public void makeStartBlock() {
        this.predecessors.add(null);
    }

    public void removeSuccessor(Jump jump) {
        SuccessorInfo successorInfo = (SuccessorInfo)this.successors.get(jump.destination);
        Jump jump2 = null;
        Jump jump3 = successorInfo.jumps;
        while (jump3 != jump && jump3 != null) {
            jump2 = jump3;
            jump3 = jump3.next;
        }
        if (jump3 == null) {
            throw new IllegalArgumentException(this.addr + ": removing non existent jump: " + jump);
        }
        if (jump2 != null) {
            jump2.next = jump3.next;
        } else if (jump3.next == null) {
            this.successors.remove(jump.destination);
            jump.destination.predecessors.remove(this);
        } else {
            successorInfo.jumps = jump3.next;
        }
    }

    public Jump getJumps(FlowBlock flowBlock) {
        return ((SuccessorInfo)this.successors.get((Object)flowBlock)).jumps;
    }

    public Jump removeJumps(FlowBlock flowBlock) {
        if (flowBlock != END_OF_METHOD) {
            flowBlock.predecessors.remove(this);
        }
        return ((SuccessorInfo)this.successors.remove((Object)flowBlock)).jumps;
    }

    public Set getSuccessors() {
        return this.successors.keySet();
    }

    public void addSuccessor(Jump jump) {
        SuccessorInfo successorInfo = (SuccessorInfo)this.successors.get(jump.destination);
        if (successorInfo == null) {
            successorInfo = new SuccessorInfo();
            successorInfo.jumps = jump;
            if (jump.destination != END_OF_METHOD) {
                jump.destination.predecessors.add(this);
            }
            this.successors.put(jump.destination, successorInfo);
        } else {
            jump.next = successorInfo.jumps;
            successorInfo.jumps = jump;
        }
    }

    public final boolean mapStackToLocal() {
        this.mapStackToLocal(VariableStack.EMPTY);
        return true;
    }

    public void mapStackToLocal(VariableStack variableStack) {
        if (variableStack == null) {
            throw new AssertError("initial stack is null");
        }
        this.stackMap = variableStack;
        this.block.mapStackToLocal(variableStack);
        Iterator iterator = this.successors.values().iterator();
        while (iterator.hasNext()) {
            SuccessorInfo successorInfo = (SuccessorInfo)iterator.next();
            Jump jump = successorInfo.jumps;
            FlowBlock flowBlock = jump.destination;
            if (flowBlock == END_OF_METHOD) continue;
            VariableStack variableStack2 = flowBlock.stackMap;
            while (jump != null) {
                if (jump.stackMap == null) {
                    GlobalOptions.err.println("Dead jump? " + jump.prev + " in " + this);
                }
                variableStack2 = VariableStack.merge(variableStack2, jump.stackMap);
                jump = jump.next;
            }
            if (flowBlock.stackMap != null) continue;
            flowBlock.mapStackToLocal(variableStack2);
        }
    }

    public void removePush() {
        if (this.stackMap == null) {
            return;
        }
        this.stackMap = null;
        this.block.removePush();
        Iterator iterator = this.successors.keySet().iterator();
        while (iterator.hasNext()) {
            FlowBlock flowBlock = (FlowBlock)iterator.next();
            flowBlock.removePush();
        }
    }

    public void removeOnetimeLocals() {
        this.block.removeOnetimeLocals();
        if (this.nextByAddr != null) {
            this.nextByAddr.removeOnetimeLocals();
        }
    }

    private void promoteInSets() {
        Iterator iterator = this.predecessors.iterator();
        while (iterator.hasNext()) {
            FlowBlock flowBlock = (FlowBlock)iterator.next();
            SuccessorInfo successorInfo = (SuccessorInfo)flowBlock.successors.get(this);
            VariableSet variableSet = successorInfo.gen;
            SlotSet slotSet = successorInfo.kill;
            this.in.merge(variableSet);
            SlotSet slotSet2 = (SlotSet)this.in.clone();
            slotSet2.removeAll(slotSet);
            if (!flowBlock.in.addAll(slotSet2)) continue;
            flowBlock.promoteInSets();
        }
        if (this.nextByAddr != null) {
            this.nextByAddr.promoteInSets();
        }
    }

    public void mergeParams(LocalInfo[] localInfoArray) {
        this.promoteInSets();
        VariableSet variableSet = new VariableSet(localInfoArray);
        this.in.merge(variableSet);
    }

    public void makeDeclaration(Set set) {
        this.block.propagateUsage();
        this.block.makeDeclaration(set);
        if (this.nextByAddr != null) {
            this.nextByAddr.makeDeclaration(set);
        }
    }

    public void simplify() {
        this.block.simplify();
        if (this.nextByAddr != null) {
            this.nextByAddr.simplify();
        }
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (this.predecessors.size() != 0) {
            tabbedPrintWriter.untab();
            tabbedPrintWriter.println(this.getLabel() + ":");
            tabbedPrintWriter.tab();
        }
        if ((GlobalOptions.debuggingFlags & 0x10) != 0) {
            tabbedPrintWriter.println("in: " + this.in);
        }
        this.block.dumpSource(tabbedPrintWriter);
        if ((GlobalOptions.debuggingFlags & 0x10) != 0) {
            Iterator iterator = this.successors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                FlowBlock flowBlock = (FlowBlock)entry.getKey();
                SuccessorInfo successorInfo = (SuccessorInfo)entry.getValue();
                tabbedPrintWriter.println("successor: " + flowBlock.getLabel() + "  gen : " + successorInfo.gen + "  kill: " + successorInfo.kill);
            }
        }
        if (this.nextByAddr != null) {
            this.nextByAddr.dumpSource(tabbedPrintWriter);
        }
    }

    public int getAddr() {
        return this.addr;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = "flow_" + this.addr + "_" + serialno++ + "_";
        }
        return this.label;
    }

    public StructuredBlock getBlock() {
        return this.block;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            TabbedPrintWriter tabbedPrintWriter = new TabbedPrintWriter(stringWriter);
            tabbedPrintWriter.println(super.toString() + ": " + this.addr + "-" + (this.addr + this.length));
            if ((GlobalOptions.debuggingFlags & 0x10) != 0) {
                tabbedPrintWriter.println("in: " + this.in);
            }
            tabbedPrintWriter.tab();
            this.block.dumpSource(tabbedPrintWriter);
            tabbedPrintWriter.untab();
            if ((GlobalOptions.debuggingFlags & 0x10) != 0) {
                Iterator iterator = this.successors.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    FlowBlock flowBlock = (FlowBlock)entry.getKey();
                    SuccessorInfo successorInfo = (SuccessorInfo)entry.getValue();
                    tabbedPrintWriter.println("successor: " + flowBlock.getLabel() + "  gen : " + successorInfo.gen + "  kill: " + successorInfo.kill);
                }
            }
            return stringWriter.toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString() + ": (RUNTIME EXCEPTION)";
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public FlowBlock(MethodAnalyzer methodAnalyzer, int n) {
        this.method = methodAnalyzer;
        this.addr = n;
    }

    static {
        END_OF_METHOD.appendBlock(new EmptyBlock(), 0);
        FlowBlock.END_OF_METHOD.label = "END_OF_METHOD";
        NEXT_BY_ADDR = new FlowBlock(null, -1);
        NEXT_BY_ADDR.appendBlock(new DescriptionBlock("FALL THROUGH"), 0);
        FlowBlock.NEXT_BY_ADDR.label = "NEXT_BY_ADDR";
        serialno = 0;
    }

    static class SuccessorInfo {
        SlotSet kill;
        VariableSet gen;
        Jump jumps;

        SuccessorInfo() {
        }
    }
}

