/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.mxjedit;

import com.cycling74.max.MXJPreferences;
import com.cycling74.mxjedit.SyntaxStyle;
import com.cycling74.mxjedit.Token;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class SyntaxUtilities {
    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, String match) {
        int length = offset + match.length();
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match.charAt(j);
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] styles = new SyntaxStyle[11];
        styles[1] = new SyntaxStyle(MXJPreferences.getMXJEditorComment1Color(), true, false);
        styles[2] = new SyntaxStyle(MXJPreferences.getMXJEditorComment2Color(), true, false);
        styles[6] = new SyntaxStyle(MXJPreferences.getMXJEditorKeyword1Color(), false, true);
        styles[7] = new SyntaxStyle(MXJPreferences.getMXJEditorKeyword2Color(), false, false);
        styles[8] = new SyntaxStyle(MXJPreferences.getMXJEditorKeyword3Color(), false, false);
        styles[3] = new SyntaxStyle(MXJPreferences.getMXJEditorLiteral1Color(), false, false);
        styles[4] = new SyntaxStyle(MXJPreferences.getMXJEditorLiteral2Color(), false, true);
        styles[5] = new SyntaxStyle(MXJPreferences.getMXJEditorLabelColor(), false, true);
        styles[9] = new SyntaxStyle(MXJPreferences.getMXJEditorOperatorColor(), false, true);
        styles[10] = new SyntaxStyle(MXJPreferences.getMXJEditorInvalidColor(), false, true);
        return styles;
    }

    public static int paintSyntaxLine(Segment line, Token tokens, SyntaxStyle[] styles, TabExpander expander, Graphics gfx, int x, int y) {
        byte id;
        Font defaultFont = gfx.getFont();
        Color defaultColor = gfx.getColor();
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                if (!defaultColor.equals(gfx.getColor())) {
                    gfx.setColor(defaultColor);
                }
                if (!defaultFont.equals(gfx.getFont())) {
                    gfx.setFont(defaultFont);
                }
            } else {
                styles[id].setGraphicsFlags(gfx, defaultFont);
            }
            line.count = length;
            x = Utilities.drawTabbedText(line, x, y, gfx, expander, 0);
            line.offset += length;
            offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    private SyntaxUtilities() {
    }
}

