/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import jode.AssertError;
import jode.GlobalOptions;
import jode.decompiler.ClassAnalyzer;
import jode.decompiler.Declarable;
import jode.decompiler.LocalInfo;
import jode.decompiler.TabbedPrintWriter;
import jode.flow.EmptyBlock;
import jode.flow.FlowBlock;
import jode.flow.Jump;
import jode.flow.SequentialBlock;
import jode.flow.VariableStack;
import jode.util.SimpleSet;

public abstract class StructuredBlock {
    Set used;
    Set declare;
    Set done;
    StructuredBlock outer;
    FlowBlock flowBlock;
    Jump jump;

    public StructuredBlock getNextBlock() {
        if (this.jump != null) {
            return null;
        }
        if (this.outer != null) {
            return this.outer.getNextBlock(this);
        }
        return null;
    }

    public void setJump(Jump jump) {
        this.jump = jump;
        jump.prev = this;
    }

    public FlowBlock getNextFlowBlock() {
        if (this.jump != null) {
            return this.jump.destination;
        }
        if (this.outer != null) {
            return this.outer.getNextFlowBlock(this);
        }
        return null;
    }

    public StructuredBlock getNextBlock(StructuredBlock structuredBlock) {
        return this.getNextBlock();
    }

    public FlowBlock getNextFlowBlock(StructuredBlock structuredBlock) {
        return this.getNextFlowBlock();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isSingleExit(StructuredBlock structuredBlock) {
        return false;
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        return false;
    }

    public StructuredBlock[] getSubBlocks() {
        return new StructuredBlock[0];
    }

    public boolean contains(StructuredBlock structuredBlock) {
        while (structuredBlock != this && structuredBlock != null) {
            structuredBlock = structuredBlock.outer;
        }
        return structuredBlock == this;
    }

    public final void removeJump() {
        if (this.jump != null) {
            this.jump.prev = null;
            this.jump = null;
        }
    }

    void moveDefinitions(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
    }

    public void replace(StructuredBlock structuredBlock) {
        this.outer = structuredBlock.outer;
        this.setFlowBlock(structuredBlock.flowBlock);
        if (this.outer != null) {
            this.outer.replaceSubBlock(structuredBlock, this);
        } else {
            this.flowBlock.block = this;
        }
    }

    public void swapJump(StructuredBlock structuredBlock) {
        Jump jump = structuredBlock.jump;
        structuredBlock.jump = this.jump;
        this.jump = jump;
        this.jump.prev = this;
        structuredBlock.jump.prev = structuredBlock;
    }

    public void moveJump(Jump jump) {
        if (this.jump != null) {
            throw new AssertError("overriding with moveJump()");
        }
        this.jump = jump;
        if (jump != null) {
            jump.prev.jump = null;
            jump.prev = this;
        }
    }

    public void copyJump(Jump jump) {
        if (this.jump != null) {
            throw new AssertError("overriding with moveJump()");
        }
        if (jump != null) {
            this.jump = new Jump(jump);
            this.jump.prev = this;
        }
    }

    public StructuredBlock appendBlock(StructuredBlock structuredBlock) {
        if (structuredBlock instanceof EmptyBlock) {
            this.moveJump(structuredBlock.jump);
            return this;
        }
        SequentialBlock sequentialBlock = new SequentialBlock();
        sequentialBlock.replace(this);
        sequentialBlock.setFirst(this);
        sequentialBlock.setSecond(structuredBlock);
        return sequentialBlock;
    }

    public StructuredBlock prependBlock(StructuredBlock structuredBlock) {
        SequentialBlock sequentialBlock = new SequentialBlock();
        sequentialBlock.replace(this);
        sequentialBlock.setFirst(structuredBlock);
        sequentialBlock.setSecond(this);
        return sequentialBlock;
    }

    public final void removeBlock() {
        if (this.outer instanceof SequentialBlock) {
            if (this.outer.getSubBlocks()[1] == this) {
                if (this.jump != null) {
                    this.outer.getSubBlocks()[0].moveJump(this.jump);
                }
                this.outer.getSubBlocks()[0].replace(this.outer);
            } else {
                this.outer.getSubBlocks()[1].replace(this.outer);
            }
            return;
        }
        EmptyBlock emptyBlock = new EmptyBlock();
        emptyBlock.moveJump(this.jump);
        emptyBlock.replace(this);
    }

    public boolean flowMayBeChanged() {
        return this.jump != null || this.jumpMayBeChanged();
    }

    public boolean jumpMayBeChanged() {
        return false;
    }

    public Set getDeclarables() {
        return Collections.EMPTY_SET;
    }

    public Set propagateUsage() {
        this.used = new SimpleSet();
        this.used.addAll(this.getDeclarables());
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        SimpleSet simpleSet = new SimpleSet();
        simpleSet.addAll(this.used);
        int n = 0;
        while (n < structuredBlockArray.length) {
            Set set = structuredBlockArray[n].propagateUsage();
            SimpleSet simpleSet2 = new SimpleSet();
            simpleSet2.addAll(set);
            simpleSet2.retainAll(simpleSet);
            this.used.addAll(simpleSet2);
            simpleSet.addAll(set);
            ++n;
        }
        return simpleSet;
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        if (structuredBlockArray.length == 0) {
            variableStack2 = variableStack;
        } else {
            variableStack2 = null;
            int n = 0;
            while (n < structuredBlockArray.length) {
                variableStack2 = VariableStack.merge(variableStack2, structuredBlockArray[n].mapStackToLocal(variableStack));
                ++n;
            }
        }
        if (this.jump != null) {
            this.jump.stackMap = variableStack2;
            return null;
        }
        return variableStack2;
    }

    public void removePush() {
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        int n = 0;
        while (n < structuredBlockArray.length) {
            structuredBlockArray[n].removePush();
            ++n;
        }
    }

    public void removeOnetimeLocals() {
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        int n = 0;
        while (n < structuredBlockArray.length) {
            structuredBlockArray[n].removeOnetimeLocals();
            ++n;
        }
    }

    public void makeDeclaration(Set set) {
        Object object;
        this.done = new SimpleSet();
        this.done.addAll(set);
        this.declare = new SimpleSet();
        Iterator iterator = this.used.iterator();
        block0: while (iterator.hasNext()) {
            Object object2;
            Object object3;
            object = (Declarable)iterator.next();
            if (set.contains(object)) continue;
            if (object instanceof LocalInfo) {
                object3 = (LocalInfo)object;
                object2 = ((LocalInfo)object3).guessName();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    LocalInfo localInfo;
                    Declarable declarable = (Declarable)iterator2.next();
                    if (!(declarable instanceof LocalInfo) || (localInfo = (LocalInfo)declarable).getMethodAnalyzer() != ((LocalInfo)object3).getMethodAnalyzer() || localInfo.getSlot() != ((LocalInfo)object3).getSlot() || !localInfo.getType().isOfType(((LocalInfo)object3).getType()) || !localInfo.isNameGenerated() && !((LocalInfo)object3).isNameGenerated() && !((String)object2).equals(localInfo.getName()) || localInfo.isFinal() || ((LocalInfo)object3).isFinal() || localInfo.getExpression() != null || ((LocalInfo)object3).getExpression() != null) continue;
                    ((LocalInfo)object3).combineWith(localInfo);
                    continue block0;
                }
            }
            if (object.getName() != null) {
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object2 = (Declarable)object3.next();
                    if (!object.getName().equals(object2.getName())) continue;
                    object.makeNameUnique();
                    break;
                }
            }
            set.add(object);
            this.declare.add(object);
            if (!(object instanceof ClassAnalyzer)) continue;
            ((ClassAnalyzer)object).makeDeclaration(set);
        }
        object = this.getSubBlocks();
        int n = 0;
        while (n < ((StructuredBlock[])object).length) {
            object[n].makeDeclaration(set);
            ++n;
        }
        set.removeAll(this.declare);
    }

    public void checkConsistent() {
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        int n = 0;
        while (n < structuredBlockArray.length) {
            if (structuredBlockArray[n].outer != this || structuredBlockArray[n].flowBlock != this.flowBlock) {
                throw new AssertError("Inconsistency");
            }
            structuredBlockArray[n].checkConsistent();
            ++n;
        }
        if (this.jump != null && this.jump.destination != null) {
            Jump jump = this.flowBlock.getJumps(this.jump.destination);
            while (jump != this.jump) {
                if (jump == null) {
                    throw new AssertError("Inconsistency");
                }
                jump = jump.next;
            }
        }
    }

    public void setFlowBlock(FlowBlock flowBlock) {
        if (this.flowBlock != flowBlock) {
            this.flowBlock = flowBlock;
            StructuredBlock[] structuredBlockArray = this.getSubBlocks();
            int n = 0;
            while (n < structuredBlockArray.length) {
                if (structuredBlockArray[n] != null) {
                    structuredBlockArray[n].setFlowBlock(flowBlock);
                }
                ++n;
            }
        }
    }

    public boolean needsBraces() {
        return true;
    }

    public void fillInGenSet(Set set, Set set2) {
    }

    public void fillSuccessors() {
        if (this.jump != null) {
            this.flowBlock.addSuccessor(this.jump);
        }
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        int n = 0;
        while (n < structuredBlockArray.length) {
            structuredBlockArray[n].fillSuccessors();
            ++n;
        }
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if ((GlobalOptions.debuggingFlags & 0x100) != 0) {
            if (this.declare != null) {
                tabbedPrintWriter.println("declaring: " + this.declare);
            }
            if (this.done != null) {
                tabbedPrintWriter.println("done: " + this.done);
            }
            tabbedPrintWriter.println("using: " + this.used);
        }
        if (this.declare != null) {
            Iterator iterator = this.declare.iterator();
            while (iterator.hasNext()) {
                Declarable declarable = (Declarable)iterator.next();
                declarable.dumpDeclaration(tabbedPrintWriter);
                tabbedPrintWriter.println(";");
            }
        }
        this.dumpInstruction(tabbedPrintWriter);
        if (this.jump != null) {
            this.jump.dumpSource(tabbedPrintWriter);
        }
    }

    public abstract void dumpInstruction(TabbedPrintWriter var1) throws IOException;

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            TabbedPrintWriter tabbedPrintWriter = new TabbedPrintWriter(stringWriter);
            tabbedPrintWriter.println(super.toString());
            tabbedPrintWriter.tab();
            this.dumpSource(tabbedPrintWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public void simplify() {
        StructuredBlock[] structuredBlockArray = this.getSubBlocks();
        int n = 0;
        while (n < structuredBlockArray.length) {
            structuredBlockArray[n].simplify();
            ++n;
        }
    }

    public boolean doTransformations() {
        return false;
    }
}

