autowatch = 1
mgraphics.init()
mgraphics.relative_coords = 0
mgraphics.autofill = 0

// we want to draw this many bars
var bars = []
for (var i=0; i < 8; i++) {
	bars.push(Math.random())
}

// Set up some default dynamic colors
var barColorToken = "live_control_selection"
var backgroundColorToken = "live_lcd_bg"

function set_bar_token(x) {
	// This is a function that is exposed in Max and lets us set the bar token
	barColorToken = x
	mgraphics.redraw()
}

function paint() {
	// First get the width and height of the box
	var [width, height] = getBoxSize()

	// Using the max.getcolor(), we can retrieve the RGBA values of dynamic color
	// Here we are retrieving a color to use for the bars.
	var barColor = max.getcolor(barColorToken)
	var bgColor = max.getcolor(backgroundColorToken)

	with (mgraphics) {

		set_source_rgba(bgColor)
		rectangle(0, 0, width, height)
		fill()

		// Now that we have the RGBA color values for the dynamic color we set for the bar...
		// ... we can pass them off to set_source_rgba() to set the color for the bars
		for (var i=0; i < bars.length; i++) {
			set_source_rgba(barColor)
			var barWidth = width / bars.length
			var margin = 2
			rectangle(i * barWidth + margin/2, height - (bars[i] * height), barWidth - margin, (bars[i] * height))
			fill()
		}
	}
}

function onclick(x, y) {
	handleBarInteraction(x, y)
}

function ondrag(x, y) {
	handleBarInteraction(x, y)
}

function handleBarInteraction(x, y) {
	var [width, height] = getBoxSize()
	var barWidth = width / bars.length
	var barIndex = Math.floor(x / barWidth)
	barIndex = Math.min(barIndex, bars.length - 1)
	var barHeight = height - y
	bars[barIndex] = barHeight / height
	mgraphics.redraw()
}

function getBoxSize () {
	// This function returns the width and height of the JSUI box.
    var width = this.box.rect[2] - this.box.rect[0]
    var height = this.box.rect[3] - this.box.rect[1]
    return [width, height]
}